function [chan] = intensity_map(chan)
%This function takes the output of syn_align, and calculates an intensity
%profile for each vertex based of the distance the vertex is away from the
%median of the distribution.
%column.  
%Synatax:   [chan] = intensity_map(chan);
%Input:     chan = the cell array chan output from syn_align
%Output:    chan = a cell array of vertices +data + intensity as the last
%               column.
for i = 1:size(chan,1)  %step through the channels
    data_tmp = chan{i}(:,1:3);     %pull data for ease of use.
    data_tmp = data_tmp.*repmat(median(data_tmp),size(data_tmp,1),1);   %figure out the proportial distance of x y z from median x y z
    data_tmp = mean(data_tmp,2).*intmax('uint16');    %create the intensity map for a 16bit image
    chan{i} = horzcat(chan{i},data_tmp);        %add the intensity data to the vertex data
end

%save to CSV or not.
uconfirm = yes_no_box('title','Do you want to save the data?','caption1','Select yes to save as a CSV file',...
    'caption2','Select no if you are not interested','position','center');
if uconfirm==1      %save data as an excel file
    %localization for macs
    if ispc
        slash = '\';        %Windows directory marker
    else
        slash = '/';        %Mac directory marker
    end
    %ok now find the points & the brightness
    [filename,pathname,filterindex] = uiputfile('.csv');
    mkdir(pathname,'int_map');      %create output directory
    %now save the files
    %channels
    for j = 1:size(chan,2)
        data_exp = dataset(chan{j});
        export(data_exp,'File',[[pathname,'int_map',slash,filename(1:end-4)],['_chan',num2str(j),'.csv']],'delimiter',',')
        %clear data
        data_exp = [];
    end
end